/** @file   tileid.h
 * @brief   Declaration of TileID - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_TILEID_H
#define H_WWW_TILEID_H

#include <string>


namespace WeWantWar {



/** @class  TileID
 * @brief   This class contains the ID-codes for special Map tiles.
 * @author  Tomi Lamminsaari
 *
 * This class has only static members so there's no need to create any
 * instances of it.
 */
class TileID
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================
  

  /** This enumeration has the indices to the @c id - array.
   */
  enum {
    ID_PLAYER,
    
    ID_ALIEN1,
    ID_ALIEN2,
    ID_ALIEN3,
    ID_ALIEN4,
    ID_ALIEN5,
    ID_ALIEN6,
    ID_ALIEN7,
    ID_ALIEN8,
    ID_ALIEN9,
    ID_ALIEN10,
    
    ID_GASLEAK,
    ID_VS_DOOR,
    ID_HS_DOOR,
    
    ID_BONUS_RIFLE,
    ID_BONUS_SHOTGUN,
    ID_BONUS_GRENADE,
    ID_BONUS_FIRSTAID,
    ID_BONUS_FLAMETHROWER,
    ID_BONUS_MINIGUN,
    ID_BONUS_UZI,
    
    ID_STATIC_LIGHT
  };
  
  /** Some special tiles on decorative map layer. These are used when the
   * ShadowTable builds the dynamic shadows of some objects. In the tilemap,
   * these tiles have the value as their user4-field.
   */
  enum {
    EHighTree = 1,
    EMediumTree,
    ELowTree
  };
  /** The id-codes for special tiles are stored here */
  static int id[256];



  /** Loads the Tile ID codes from given file.
   * @param     tileidfile        Name of the file containing the tile idcodes.
   */
  void loadIDCodes( const std::string& tileidfile );
  


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	TileID();


	/** Destructor
   */
	virtual ~TileID();

	/** Copy constructor.
   * @param     rO                Reference to another TileID
   */
  TileID( const TileID& rO );

	/** Assignment operator
   * @param     rO                Reference to another TileID
   * @return    Reference to us.
   */
  TileID& operator = ( const TileID& rO );



  ///
  /// Methods
  /// =======



  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace


#endif

/**
 * Version history
 * ===============
 * $Log: tileid.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.1  2005-11-13 14:27:11+02  lamminsa
 * Id codes for shadow tiles were added.
 *
 */
 
